#define S_FUNCTION_NAME dstcore3

/*
 * Need to include simstruc.h for the definition of the SimStruct and
 * its associated macro definitions.
 */

#include "simstruc.h"
#include "math.h"

/* Number of Plates */
#define N 27
/* Feed Plate */
#define FP 14

static void mdlInitializeSizes(SimStruct *S)
{
    ssSetNumContStates(    S, 2*N+6);   /* number of continuous states           */
    ssSetNumDiscStates(    S, 0);   /* number of discrete states             */
    ssSetNumInputs(        S, 4);   /* number of inputs                      */
    ssSetNumOutputs(       S, 2);   /* number of outputs                     */
    ssSetDirectFeedThrough(S, 0);   /* direct feedthrough flag               */
    ssSetNumSampleTimes(   S, 1);   /* number of sample times                */
    ssSetNumSFcnParams(    S, 0);   /* number of input arguments             */
    ssSetNumRWork(         S, 0);   /* number of real work vector elements   */
    ssSetNumIWork(         S, 0);   /* number of integer work vector elements*/
    ssSetNumPWork(         S, 0);   /* number of pointer work vector elements*/
}

/*
 * mdlInitializeSampleTimes - initialize the sample times array
 *
 * This function is used to specify the sample time(s) for your S-function.
 * You must register the same number of sample times as specified in 
 * ssSetNumSampleTimes. If you specify that you have no sample times, then
 * the S-function is assumed to have one inherited sample time.
 *
 * The sample times are specified period, offset pairs. The valid pairs are:
 *
 *   [CONTINUOUS_SAMPLE_TIME   0     ]  : Continuous sample time.
 *   [period                   offset]  : Discrete sample time where
 *					  period > 0.0 and offset < period or
 *				          equal to 0.0.
 *   [VARIABLE_SAMPLE_TIME     0     ]  : Variable step discrete sample time
 *				          where mdlGetTimeOfNextVarHit is
 *				          called to get the time of the next
 *					  sample hit.
 *
 *  or you can specify that the sample time is inherited from the driving
 *  block in which case the S-function can have only one sample time:
 *    [INHERITED_SAMPLE_TIME    0    ]
 */
static void mdlInitializeSampleTimes(SimStruct *S)
{
    ssSetSampleTime(S, 0, CONTINUOUS_SAMPLE_TIME);
    ssSetOffsetTime(S, 0, 0.0);
    
    /*
     * SET OTHER SAMPLE TIMES AND OFFSETS HERE
     */
}


/*
 * mdlInitializeConditions - initialize the states
 *
 * In this function, you should initialize the continuous and discrete
 * states for your S-function block.  The initial states are placed
 * in the x0 variable.  You can also perform any other initialization
 * activities that your S-function may require.
 */
static void mdlInitializeConditions(double *x0, SimStruct *S)
{
   
/* Initial conditions for reflux ratio = 1.75, vapor flow rate = 0.033 */
	x0[0]=0;
	x0[1]=0.52590575848762;
	x0[2]=0.53482369704958;
	x0[3]=0.54332878857830;
	x0[4]=0.55097792368632;
	x0[5]=0.55749990730388;
	x0[6]=0.56281191107659;
        x0[7]=0.56698597237933;
        x0[8]=0.57017114888270;
        x0[9]=0.57255213339674;
        x0[10]=0.57430823454415;
        x0[11]=0.57559431673351;
        x0[12]=0.57653502950211;
        x0[13]=0.57722619552256;
        x0[14]=0.57773923394677;
        x0[15]=0.52875194018825;
        x0[16]=0.52901098755298;
        x0[17]=0.52939210247904;
        x0[18]=0.52995891013126;
        x0[19]=0.53080746429403;
        x0[20]=0.53208165063181;
        x0[21]=0.53399435874894;
        x0[22]=0.53685446478458;
        x0[23]=0.54109631521597;
        x0[24]=0.54730046098700;
        x0[25]=0.55617927644367;
        x0[26]=0.56848034205965;
        x0[27]=0.58475177199408;
        x0[28]=0.10870731156973;
        x0[29]=0.13987738770930;
        x0[30]=0.16952598580129;
        x0[31]=0.19611899444865;
        x0[32]=0.21872788806265;
        x0[33]=0.23708250447851;
        x0[34]=0.25144763628194;
        x0[35]=0.26235118617392;
        x0[36]=0.27044409838411;
        x0[37]=0.27635482825610;
        x0[38]=0.28062494329783;
        x0[39]=0.28368973393940;
        x0[40]=0.28588350517124;
        x0[41]=0.28745525362488;
        x0[42]=0.26326966434612;
        x0[43]=0.26381388717519;
        x0[44]=0.26476602216993;
        x0[45]=0.26633973201269;
        x0[46]=0.26885756275489;
        x0[47]=0.27280263777794;
        x0[48]=0.27888968872289;
        x0[49]=0.28815553338760;
        x0[50]=0.30205784240796;
        x0[51]=0.32254436516698;
        x0[52]=0.35200407751002;
        x0[53]=0.39294217832184;
        x0[54]=0.44719196316636;
        x0[55]=0.15059146369614;
        x0[56]=0.85070750160721;
        x0[57]=0.03431122209885;
        x0[58]=0.04552319196410;
	x0[59] =   -1000;

/* Initial conditions for Reflux Ratio = 2.2, Vapor Flow Rate = 0.033
	x0[0] =0;
	x0[1] =0.52474904127504;
	x0[2] =0.53197482607049;
	x0[3] =0.53963243123780;
	x0[4] =0.54735266595854;
	x0[5] =0.55474968391119;
	x0[6] =0.56149606594675;
	x0[7] =0.56737613745942;
	x0[8] =0.57230153732470;
	x0[9] =0.57629937374542;
	x0[10] =0.57945676672211;
	x0[11] =0.58190123560933;
	x0[12] =0.58376774165578;
	x0[13] =0.58518097533791;
	x0[14] =0.58624734319082;
	x0[15] =0.54009716527916;
	x0[16] =0.54084276510943;
	x0[17] =0.54189186548410;
	x0[18] =0.54336496403262;
	x0[19] =0.54542484522807;
	x0[20] =0.54828575386803;
	x0[21] =0.55221877135270;
	x0[22] =0.55754655760824;
	x0[23] =0.56461652265468;
	x0[24] =0.57373915998782;
	x0[25] =0.58508396323822;
	x0[26] =0.59854754394223;
	x0[27] =0.61364739050035;
	x0[28] =0.07577570111730;
	x0[29] =0.10127563230199;
	x0[30] =0.12823964191546;
	x0[31] =0.15535764645871;
	x0[32] =0.18127503802004;
	x0[33] =0.20485064201580;
	x0[34] =0.22534062278655;
	x0[35] =0.24244983480847;
	x0[36] =0.25628499600788;
	x0[37] =0.26715801772461;
	x0[38] =0.27552328248830;
	x0[39] =0.28185755158724;
	x0[40] =0.28659998751211;
	x0[41] =0.29012465897349;
	x0[42] =0.26850430557942;
	x0[43] =0.27071427258638;
	x0[44] =0.27395011813699;
	x0[45] =0.27861969116323;
	x0[46] =0.28527378665047;
	x0[47] =0.29463699305524;
	x0[48] =0.30762555376689;
	x0[49] =0.32532908191702;
	x0[50] =0.34891918592815;
	x0[51] =0.37944037061637;
	x0[52] =0.41745810368663;
	x0[53] =0.46261415463867;
	x0[54] =0.51327018443430;
	x0[55] =0.10179538514196;
	x0[56] =0.89991475572448;
	x0[57] =0.03991429147421;
	x0[58] =0.05052678391431;
	x0[59] =-1000.;
 */


}

/*
 * mdlOutputs - compute the outputs
 *
 * In this function, you compute the outputs of your S-function
 * block.  The outputs are placed in the y variable.
 */

static void mdlOutputs(double *y, double *x, double *u, SimStruct *S, int tid)
{
    	int i,k;

   y[0] = x[2*N+2];

   y[1] = x[2*N+1];
}

/*
 * mdlUpdate - perform action at major integration time step
 *
 * This function is called once for every major integration time step.
 * Discrete states are typically updated here, but this function is useful
 * for performing any tasks that should only take place once per integration
 * step.
 */

static void mdlUpdate(double *x, double *u, SimStruct *S, int tid)
{
    /*
     * YOUR CODE GOES HERE
     */
}

/*
 * mdlDerivatives - compute the derivatives
 *
 * In this function, you compute the S-function block's derivatives.
 * The derivatives are placed in the dx variable.
 */

static void mdlDerivatives(double *dx, double *x, double *u, SimStruct *S, int tid)
{
   double  zx[N+3], tf, md0, mb0, pm1, pe1;
   double  tt01, tt02, tt[N+3], f, pm2, pe2, p[N+3];
   double  m, f2, f1, ml[N+3], de[N+3], zy[N+3], d, b;		
   double  hv[N+3], hl[N+4], term1, term2, how, l[N+1], lr, v[N+1];
   int i;
   /* double pow(),exp();   */

   for (i=0;i<N+3;++i) {                                      /* fills arrays with zeros */
      tt[i]=p[i]=ml[i]=de[i]=zy[i]=hv[i]=0;
      }
   for(i=0;i<N+1;++i){
      l[i]=v[i]=0;
      }
   for(i=0;i<N+4;++i){
      hl[i]=0;
      }     

   dx[0]=0.0;
   dx[59]=1.0;
	
   tf=346.1666666666667;   /* feed temp */
   md0=5.5;    /* compressor and boiler holdups */
   mb0=5.5; 
   p[1]=1.2295;  /* tray pressure calculations */
   for (i=2; i <= N; ++i) {
   p[i]=p[i-1]-0.0085;
   }
   p[N+1]=1.238;
   p[N+2]=1.0;

   zx[N+1] = x[2*N+1];      /* methanol mole fraction per tray */
   if (zx[N+1] < 0.0) {zx[N+1]=0.0;}
   zx[N+2] = x[2*N+2];
   if (zx[N+2] > 1.0) {zx[N+2]=1.0;}
	
   tt[0] = 0.0;
   for (i=1; i <= N+2; ++i) {      /* find tray temps, bubble points */
      if (i<=N) {zx[i] = x[N+i]/x[i];}  /* botom and top temps in i=i+1, i+2 */
      tt01=337.5;   /* set range for temp */
      tt02=357.0;
      f=1.0;
      tt[i]=0.0;
      while (f > 0.0001) {
         pm1=exp(18.5875-3626.55/(tt01-34.29));
         pm2=exp(18.5875-3626.55/(tt02-34.29));
	 pe1=exp(18.9119-3803.98/(tt01-41.68));
	 pe2=exp(18.9119-3803.98/(tt02-41.68));
	 f1=(zx[i]*pm1+(1-zx[i])*pe1)/760-p[i];
	 f2=(zx[i]*pm2+(1-zx[i])*pe2)/760-p[i];
	 m=(f1-f2)/(tt01-tt02);
	 tt[i]=tt02-f2/m;
	 pm1=exp(18.5875-3626.55/(tt[i]-34.29));
	 pe1=exp(18.9119-3803.98/(tt[i]-41.68));
	 f=(zx[i]*pm1+(1-zx[i])*pe1)/760 - p[i];
	 if (f > 0) {tt02 = tt[i];}
	 if (f < 0) {
	    tt01 = tt[i];
	    f = -f;}
	 }
	
      /* physical / thermodynamic properities */
      ml[i]=46.069-14.027*zx[i];   /* average liq mol weight */
      de[i]=zx[i]*(67.43-0.0341*1.8*tt[i])+(1-zx[i])*(66.96-0.0332*1.8*tt[i]);
	                  /* avg liq density */
      zy[i]=zx[i]*exp(18.5875-3626.55/(tt[i]-34.29));
                          /* methanol mole fraction in vapor */
      zy[i]=zy[i]/(p[i]*760);
	
 term1=(-3.065e-9)*tt[i]*tt[i]*tt[i]*tt[i]+(3.7047e-6)*tt[i]*tt[i]*tt[i]+(1.5246e-2)*tt[i]*tt[i]+9.0936*tt[i]+5798.69;
 term2=(1.476e-9)*tt[i]*tt[i]*tt[i]*tt[i]+(-1.2024e-5)*tt[i]*tt[i]*tt[i]+(4.6e-2)*tt[i]*tt[i]+ 3.8754*tt[i]+ 6750.02;
      hv[i]=zy[i]*term1+(1-zy[i])*term2; /* calc enthalpy of vapor */
	
      term1=(1.382e-4)*tt[i]*tt[i]*tt[i]-0.0776*tt[i]*tt[i]+43.88*tt[i]-9007.665;
      term2=(2.166e-4)*tt[i]*tt[i]*tt[i]-0.1039*tt[i]*tt[i]+ 52.61*tt[i] -11026;
      hl[i]=zx[i]*term1+(1-zx[i])*term2;	}
	
      term1=(1.382e-4)*tf*tf*tf-0.0776*tf*tf+ 43.88*tf -9007.665;
      term2=(2.166e-4)*tf*tf*tf-0.1039*tf*tf+ 52.61*tf -11026;
      hl[N+3]=u[1]*term1+(1.0-u[1])*term2;
	
      for (i=1; i<=N; ++i) {
         how=12.0*x[i]*ml[i]/(de[i]*2.32) - 2.0;
	 if (how<0.0) {how=0.0;}
	 l[i]=2.0261*pow((how/0.48),1.5)*de[i]/ml[i]/60;
         }
      lr=x[2*N+3]*(1.0-1.0/(u[3]+1.0));
      dx[2*N+4]=l[1]-x[2*N+4];
	
      v[1]=(l[2]*hl[2]-l[1]*hl[1]+u[2]*hv[N+1])/hv[1];
      if (v[1]<0.0) {v[1]=0.0;}
      for (i=2; i<=N-1; ++i) {
         if (i != FP) {
	    v[i]=(l[i+1]*hl[i+1]-l[i]*hl[i]+v[i-1]*hv[i-1])/hv[i];}
	 else {
	    term1=l[FP+1]*hl[FP+1]-l[FP]*hl[FP]+v[FP-1]*hv[FP-1];
	    v[FP]=(term1+u[0]*hl[N+3])/hv[FP];}			
	 if (v[i]<0.0) {v[i] = 0.0;}			}
	 v[N]=(lr*hl[N+2]-l[N]*hl[N]+v[N-1]*hv[N-1])/hv[N];
	 if (v[N]<0.0) {v[N] = 0.0;}
	 dx[2*N+3]=v[N]-x[2*N+3];
	
	 d=v[N]-lr;
	 if (d<0.0) {d=0.0;}
	 b=l[1]-u[2];
	 if (b<0.0) {b=0.0;}
	
	 dx[N]=lr+v[N-1]-l[N]-v[N];
	 dx[2*N]=zx[N+2]*lr+zy[N-1]*v[N-1]-v[N]*zy[N]-l[N]*zx[N];
	 dx[1]=l[2]+u[2]-l[1]-v[1];
	 dx[N+1]=zx[2]*l[2]+zy[N+1]*u[2]-zx[1]*l[1]-zy[1]*v[1];
	 for (i=2; i<=N-1; i=i+1) {
	    dx[i]=l[i+1]-l[i]+v[i-1]-v[i];
	    dx[N+i]=l[i+1]*zx[i+1]-l[i]*zx[i]+v[i-1]*zy[i-1]-v[i]*zy[i];
            }
	 dx[FP]=l[FP+1]-l[FP]+v[FP-1]-v[FP]+u[0];
	 dx[N+FP]=l[FP+1]*zx[FP+1]-l[FP]*zx[FP]+v[FP-1]*zy[FP-1];
	 dx[N+FP]=dx[N+FP]-v[FP]*zy[FP]+u[0]*u[1];
	 dx[2*N+1]=(l[1]*zx[1]-b*zx[N+1]-u[2]*zy[N+1])/mb0;
	 dx[2*N+2]=(v[N]*zy[N]-(lr+d)*zx[N+2])/md0;

}


#if 0  /* Change to a 1 if VARIABLE_SAMPLE_TIME has been specified */
/*
 * mdlGetTimeOfNextVarHit - Get the time of the next variable sample time hit
 *  
 * This function is called one for every major integration time step.
 * It must return time of next hit by using ssSetTNext. The time of the
 * next hit must be greater than ssGetT(S).
 */
#define MDL_GET_TIME_OF_NEXT_VAR_HIT
static void mdlGetTimeOfNextVarHit(SimStruct *S)
{
    ssSetTNext(S, <timeOfNextHit>);
}
#endif

/*
 * mdlTerminate - called when the simulation is terminated.
 *
 * In this function, you should perform any actions that are necessary
 * at the termination of a simulation.  For example, if memory was allocated
 * in mdlInitializeConditions, this is the place to free it.
 */

static void mdlTerminate(SimStruct *S)
{
    /*
     * YOUR CODE GOES HERE
     */
}

#ifdef	MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */
#include "simulink.c"      /* MEX-file interface mechanism */
#else
#include "cg_sfun.h"       /* Code generation registration function */
#endif
